/*
 * Copyright (c) 2007 Apple Inc. All Rights Reserved.
 * 
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

/*!
	@header SecIntegrityLib
	This header provides a subset of the code-integrity API for Code Signing.
	This subset functionality is implemented as a static library written
	entirely in C, and depends on nothing except the system library and the
	C runtime. It is thus suitable to be used by low-level libraries and
	other such system facilities. On the other hand, it does not provide the
	full functionality of <Security/SecIntegrity.h>.
	
	This file is documented as a delta to <Security/SecIntegrity.h>, which
	you should consult as a baseline.
*/
#ifndef _H_SECINTEGRITYLIB
#define _H_SECINTEGRITYLIB

#include "SecIntegrity.h"

#ifdef __cplusplus
extern "C" {
#endif


/*
	This file is not yet published.
 */
 

#ifdef __cplusplus
}
#endif

#endif //_H_SECINTEGRITYLIB
